// DIbufferDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DIbuffer.h"
#include "DIbufferDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDIbufferDlg dialog

CDIbufferDlg::CDIbufferDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDIbufferDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDIbufferDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDIbufferDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDIbufferDlg)
	DDX_Control(pDX, IDC_LIST1, m_readlist);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDIbufferDlg, CDialog)
	//{{AFX_MSG_MAP(CDIbufferDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_QUIT, OnQuit)
	ON_BN_CLICKED(IDC_START, OnStart)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDIbufferDlg message handlers

BOOL CDIbufferDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_logicalDevice=0;  //Set this to a different device number if necessary
	m_logicalChannel=0; //Channel 0 is going to be used
	m_samples=10; //This will set the number of samples to read; only need to change it here if more samples are to be read
	m_DLmsg=RegisterWindowMessage(DL_MESSAGE); //Need to register DriverLINX messages to detect when the buffer is filled
	m_pSR=(DL_ServiceRequest*) new DL_ServiceRequest; //Allocate memory for the service request
	m_driverInstance=OpenDriverLINX(m_hWnd,"");  //Open a dialog to select the DriverLINX driver
	memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request to 0
	DL_SetServiceRequestSize(*m_pSR); //Need to set the size of the service request
	m_pSR->device=m_logicalDevice;
	m_pSR->operation=INITIALIZE;
	m_pSR->subsystem=DEVICE;
	m_pSR->mode=OTHER;
	m_pSR->hWnd=m_hWnd; //Need to set the hWnd member of the service request to the window handle of the application
	DriverLINX(m_pSR); //Execute the service request
	showMessage(m_pSR); //show errors, if any
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDIbufferDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDIbufferDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDIbufferDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX; //Use a message box to show errors
	DriverLINX(SR); //Execute the service request
	return;
}

void CDIbufferDlg::OnQuit() 
{
	// TODO: Add your control notification handler code here
	clearBuffer();  //See the clearBuffer definition for details
	delete m_pSR; //De-allocate the memory used by the service request
	m_pSR=NULL;
	CloseDriverLINX(m_driverInstance); //Close the DriverLINX driver
	m_driverInstance=NULL;
	OnOK(); //Quit the application
}

void CDIbufferDlg::OnStart() 
{
	// TODO: Add your control notification handler code here
	clearBuffer(); //Clear any existing buffers
	memset(m_pSR,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*m_pSR);
	m_pSR->hWnd=m_hWnd;
	m_pSR->device=m_logicalDevice;
	m_pSR->operation=START;
	m_pSR->mode=INTERRUPT;
	m_pSR->subsystem=DI;
	m_pSR->timing.typeEvent=DIEVENT; //Use the external interrupt line to pace the digital input
	m_pSR->timing.u.diEvent.channel=DI_EXTCLK;
	m_pSR->timing.u.diEvent.mask=1;
	m_pSR->timing.u.diEvent.match=FALSE;
	m_pSR->timing.u.diEvent.pattern=0;
	m_pSR->start.typeEvent=COMMAND;
	m_pSR->stop.typeEvent=TCEVENT; //Stop when the number of samples has been read
	m_pSR->channels.nChannels=1;
	m_pSR->channels.chanGain[0].channel=m_logicalChannel;
	m_pSR->channels.numberFormat=tNATIVE;
	m_pSR->lpBuffers=(DL_BUFFERLIST*)new BYTE[DL_BufferListBytes(1)]; //Create a list of buffers;  in this case, just one
	m_pSR->lpBuffers->notify=NOTIFY; //Enable the buffer_filled message
	m_pSR->lpBuffers->nBuffers=1; //Only one buffer will be used
	m_pSR->lpBuffers->bufferSize=Samples2Bytes(0,DI,0,m_samples);
	m_pSR->lpBuffers->BufferAddr[0]=BufAlloc(GBUF_INT,m_pSR->
		lpBuffers->bufferSize); //Allocate enough memory in the buffer for the number of samples
	DriverLINX(m_pSR);
	showMessage(m_pSR);
}

LRESULT CDIbufferDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(message==m_DLmsg) //Was a DriverLINX message posted?
	{
		switch(wParam)
		{
		case DL_BUFFERFILLED: //Was the Buffer_Filled message posted?
			done(); //If so, call the done() function to take care of the post acquisition tasks
			break;
		}
	}
	return CDialog::WindowProc(message, wParam, lParam);
}

void CDIbufferDlg::done()
{
	m_readlist.ResetContent(); //Clear the listbox to show the samples
	m_pData=(BYTE*)m_pSR->lpBuffers->BufferAddr[0]; //Copy the contents of BufferAddr[0] to the local pointer, and cast as an array of bytes
													//It is necessary to specify byte, because the channel is only 8 bits wide, but the buffer
													//elements are 32 bits wide	
	int index;
	CString str;
	for(index=0;index<m_samples;index++)
	{
		str.Format("%d",m_pData[index]);  //Format the sample as a string to display it in the listbox
		m_readlist.AddString(str); //Add the current sample to the listbox
	}
	UpdateData(FALSE); //Update the listbox display
}

void CDIbufferDlg::clearBuffer()
{
	if(m_pSR!=NULL) //Check to see if a service request exists first
	{
		if(m_pSR->lpBuffers!=NULL) //Check to see if a buffer list has been defined
		{
			if(m_pSR->lpBuffers->BufferAddr[0]!=NULL) 
			{
				BufFree(m_pSR->lpBuffers->BufferAddr[0]); //Free the buffer memory if one exists
				m_pSR->lpBuffers->BufferAddr[0]=NULL;
			}
			delete(m_pSR->lpBuffers); //Clear the buffer list AFTER the buffer itself has been cleared
			m_pSR->lpBuffers=NULL;
		}
	}
}
